<img src="https://r2cdn.perplexity.ai/pplx-full-logo-primary-dark%402x.png" style="height:64px;margin-right:32px"/>



# Comment Faire pour que le ssh fonctionne sur mon raspberry pi 3B+ 
	avec server ubuntu 24 LTD sans desktop

Pour faire fonctionner SSH sur un Raspberry Pi 3B+ avec Ubuntu Server 24.04 LTS 
	(sans interface graphique), il faut surtout vérifier trois choses : 
	que le paquet SSH est installé, que le service est actif et que le réseau/IP sont corrects.

## 1. Installer le serveur SSH

Sur Ubuntu Server, le serveur SSH (openssh-server) est souvent déjà présent, mais il vaut mieux vérifier. 
	Connecte-toi au Raspberry Pi avec clavier/écran (ou via console série) et tape :

```bash

sudo apt update
sudo apt install openssh-server

```

Si le service n’est pas activé automatiquement :

```bash

sudo systemctl enable ssh
sudo systemctl start ssh

```

Ensuite vérifie le service :

```bash

sudo systemctl status ssh

```

Le service doit être en `active (running)` ou similaire.


## 2. Activer et démarrer le service au boot



Sur Ubuntu 24.04, le service peut s’appeler 
	`ssh.service` (et non `sshd.service`), c’est normal.

## 3. Vérifier l’adresse IP du Raspberry Pi

Toujours sur le Pi, récupère son IP sur le réseau local :

```bash

ip a

```

Note l’IP de l’interface connectée (souvent `eth0` ou `wlan0`, par ex. `192.168.1.23`). 
	Sur ton PC (Linux/macOS) ou dans PowerShell (Windows) :

```bash

ssh utilisateur@192.168.1.23

Ex: ssh ubuntu@192.168.74.130

```

Remplace `utilisateur` par ton login Ubuntu sur le Pi.

-----------------------------------------------------------------

## 4. Si la connexion SSH échoue

Quelques points à vérifier :

- Pare-feu UFW désactivé ou ouvert sur le port 22 :

```bash

sudo ufw allow 22/tcp
sudo ufw enable    # seulement si ufw doit être activé

```

- Tester que le port 22 écoute bien :

```bash

sudo ss -tulpen | grep ssh

```

- Tester un ping depuis ton PC vers l’IP du Pi pour confirmer la connectivité réseau.

+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

## 5. Optionnel : sécuriser SSH

Une fois que ça fonctionne, tu peux :

- Créer des clés SSH sur ton PC et copier la clé publique sur le Pi (`ssh-copy-id`).
- Modifier `/etc/ssh/sshd_config` pour désactiver l’authentification par mot de passe :
    - `PasswordAuthentication no`
    - puis : `sudo systemctl restart ssh`

Cela renforce beaucoup la sécurité de ton Raspberry Pi.

